package com.example.sefinsa_app.ui.folios.ver;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.util.Base64;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.RecyclerView;

import com.example.sefinsa_app.R;
import com.example.sefinsa_app.controllers.FolioController;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.models.Folio;
import com.example.sefinsa_app.ui.folios.Folios;
import com.example.sefinsa_app.utilities.BluetoothUtils;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;

public class FolioAdapter extends RecyclerView.Adapter<FolioAdapter.ViewHolder> {

    private ArrayList<Folio> folios;
    private Context context;
    private FragmentActivity activity;
    private final Folios fragment;

    public FolioAdapter(ArrayList<Folio> folios, Context context, FragmentActivity activity, Folios fragment) {
        this.folios = folios;
        this.context = context;
        this.activity = activity;
        this.fragment = fragment;
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private TextView tvnFolio;
        private TextView tvfechaHora;
        private TextView tvNombre;
        private TextView tvPoblacion;
        private TextView tvMonto;
        private MaterialButton btnConcepto;
        private MaterialButton btnFirmas;
        private MaterialButton btnImpresora;


        public ViewHolder(@NonNull View view) {
            super(view);

            tvnFolio = view.findViewById(R.id.tvnFolio);
            tvfechaHora = view.findViewById(R.id.tvfechaHora);
            tvNombre = view.findViewById(R.id.tvNombreCliente);
            tvPoblacion = view.findViewById(R.id.tvPoblacion);
            tvMonto = view.findViewById(R.id.tvMonto);
            btnConcepto = view.findViewById(R.id.btnConcepto);
            btnFirmas = view.findViewById(R.id.btnFirmas);
            btnImpresora = view.findViewById(R.id.btnImpresora);
        }
    }

    @NonNull
    @Override
    public FolioAdapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.folio_item, parent, false);
        return new ViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull FolioAdapter.ViewHolder holder, @SuppressLint("RecyclerView") int position) {
        Folio folio = folios.get(position);

        String nFolio = folio.getId();
        String fecha = folio.getFecha();
        String cliente_id = folio.getCliente_id();
        String monto = folio.getMonto();
        String concepto = folio.getConcepto();
        String firmaUsuario = folio.getFirma_usuario();
        String firmaCliente = folio.getFirma_cliente();

        holder.tvnFolio.setText("Folio: " + nFolio);
        holder.tvfechaHora.setText(fecha);
        holder.tvNombre.setText("Recibido de: " + cliente_id);
        FolioController fc = new FolioController(context);
        String p = fc.getPoblacion(folio.getPoblacion_id());
        holder.tvPoblacion.setText("Población: " + p);
        holder.tvMonto.setText("Monto: $" + monto);

        holder.btnConcepto.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                androidx.appcompat.app.AlertDialog.Builder builder = new androidx.appcompat.app.AlertDialog.Builder(context);
                builder.setTitle("Concepto");
                builder.setMessage(concepto);

                builder.setPositiveButton("Cerrar", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int id) {
                    }
                });

                AlertDialog dialog = builder.create();
                dialog.show();
            }
        });

        holder.btnFirmas.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                SharedPreferences p = context.getSharedPreferences("firmas", Context.MODE_PRIVATE);
                SharedPreferences.Editor e = p.edit();

                e.putString("firmaUsuario", firmaUsuario);
                e.putString("firmaCliente", firmaCliente);
                e.commit();

                VerFirmasFragment dialog = new VerFirmasFragment();
                dialog.show(activity.getSupportFragmentManager(), "verFirmasDialog");
            }
        });

        RutaController rc = new RutaController(context);
        String ruta = rc.getNombreRuta(folio.getRuta_id());

        PoblacionController pc = new PoblacionController(context);
        String poblacion = pc.getNombrePoblacion(folio.getPoblacion_id());

        byte[] decodedBytes = Base64.decode(folio.getFirma_cliente(), Base64.DEFAULT);
        Bitmap bitmapFC = BitmapFactory.decodeByteArray(decodedBytes, 0, decodedBytes.length);

        byte[] decodedBytes2 = Base64.decode(folio.getFirma_usuario(), Base64.DEFAULT);
        Bitmap bitmapFA = BitmapFactory.decodeByteArray(decodedBytes2, 0, decodedBytes2.length);

        holder.btnImpresora.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                AlertDialog.Builder builder6 = new AlertDialog.Builder(context);
                builder6.setTitle("Seleccionar Opcion")
                        .setPositiveButton("Reimprimir Folio", new DialogInterface.OnClickListener() {
                            @RequiresApi(api = Build.VERSION_CODES.O)
                            @Override
                            public void onClick(DialogInterface dialog, int which) {
                                new MaterialAlertDialogBuilder(context)
                                        .setTitle("Reimprimir folio")
                                        .setMessage("¿Quieres reimprimir el folio de " + folio.getId() + "?")
                                        .setPositiveButton("Sí", new DialogInterface.OnClickListener() {
                                            @RequiresApi(api = Build.VERSION_CODES.O)
                                            @Override
                                            public void onClick(DialogInterface dialogInterface, int i) {

                                                BluetoothUtils.context = context;
                                                BluetoothUtils.printPhoto(R.drawable.credigrup_ticket_3);
                                                try {
                                                    if (BluetoothUtils.mConnectedThread != null) {
                                                        BluetoothUtils.printReimpresion(folio, ruta, poblacion, cliente_id, bitmapFA, bitmapFC);
                                                    } else {
                                                        Toast.makeText(context, "No hay conexión con la impresora", Toast.LENGTH_SHORT).show();
                                                    }
                                                } catch (ParseException e) {
                                                    e.printStackTrace();
                                                } catch (IOException e) {
                                                    throw new RuntimeException(e);
                                                }
                                            }
                                        })
                                        .setNegativeButton("No", new DialogInterface.OnClickListener() {
                                            @Override
                                            public void onClick(DialogInterface dialogInterface, int i) {

                                            }
                                        })
                                        .show();
                            }
                        })
                        .setNeutralButton("Compartir", new DialogInterface.OnClickListener() {
                            @RequiresApi(api = Build.VERSION_CODES.O)
                            @Override
                            public void onClick(DialogInterface dialog, int which) {
                                try {
                                    fragment.compartirPagoReporteFolio(folio);
                                } catch (ParseException e) {
                                    e.printStackTrace();
                                }
                            }
                        })
                        .setNegativeButton("Cerrar", new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialog, int which) {
                                dialog.dismiss();
                            }
                        })
                        .show();
            }
        });
    }

    @Override
    public int getItemCount() {
        return folios.size();
    }
}
